<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Post;
use App\Submission;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Hash;


class DashboardController extends Controller
{
    public function index(){
        $posts = Post::get();
        $submissions = Submission::all();
        return view('admin.index', compact('posts','submissions'));
    }

    public function showProfile(){

        $user = User::find(Auth::user()->id);
        
        return view('admin.profile', compact('user'));
    }

    public function updateProfile(Request $request){
        $this->validate($request,[
            'name' => 'required',
            'userid' => 'required|unique:users',
            'about' => 'sometimes|max:255',
            'image' => 'sometimes|image|mimes:jpg,png,bmp,jpeg|max:2000'
        ]);

        $user = User::findOrFail(Auth::user()->id);
        if ($request->image != null){ 
            //image
            $image = $request->image; 
            $imageName = Str::slug($request->name,'-').uniqid().'.'.$image->getClientOriginalExtension();
            if(!storage::disk('public')->exists('user')){
                Storage::disk('public')->makeDirectory('user');
            }
            //Delete old image 
            if($user->image !== 'default.jpg' && Storage::disk('public')->exists('user/'.$user->image)){
                storage::disk('public')->delete('user/'.$user->image);
            }
            //Store
            // $image->storeAs('category',$imageName,'public');
            $userImg = Image::make($image)->fit(200,200)->stream();
            Storage::disk('public')->put('user/'.$imageName,$userImg);
        }else{
            $imageName = $user->image;
        }
       
        $user->name = $request->name; 
        $user->userid = $request->userid;
        $user->image = $imageName;
        $user->about = $request->about;
 
        $user->save();
        Toastr::success('Details Updated successfully :)','success');
        return redirect()->back();



    }


    public function changePassword(Request $request){
        $this->validate($request, [
            'old_password' => 'required',
            'password' => 'required|max:255|confirmed'
        ]);
        //cross the old password
        $oldPass = Auth::user()->password; //hashed
        if(Hash::check($request->old_password,$oldPass)){
            if(!Hash::check($request->password,$oldPass)){
                $user = User::find(Auth::id());
                $user->password = Hash::make($request->password);
                $user->save();

                //Logout
                Auth::logout();
                return redirect()->back();
            }else{
                Toastr::error('Old and New password Same');
                return redirect()->back();
            }
        }else{
            Toastr::error('Enter the correct Old password :(');
            return redirect()->back();
        }
    }










}
