<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Post;
use App\Category;
use App\Photo;
use App\Tag;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Stevebauman\Location\Facades\Location;
// use Stevebauman\Location\Facades\Location as FacadesLocation;
// use Stevebauman\Location\Drivers\Driver;

class HomeController extends Controller
{


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $posts = Post::latest()->take(4)->published()->get();
        return view('index', compact('posts'));
    }

    public function posts()
    {
        $posts = Post::latest()->published()->paginate(10);

        return view('posts', compact('posts'));
    }

    public function post($slug)
    {
        $post = Post::where('slug',$slug)->published()->first();
        // $posts = Post::latest()->take(3)->published()->get();
        //Increase View Count
        $postKey = 'post_'.$post->id;
        if(!Session::has($postKey)){
            $post->increment('view_count');
            Session::put($postKey, 1);
        }
        return view('post', compact('post'));
    }

    public function categoryposts($id){
        $catpost = Post::where('category_id',$id)->published()->get();
        return view('catpost', compact('catpost'));
    }


    public function categories()
    {
        $categories = Category::all();
        return view('index',compact('categories'));
    }

    public function categoryPost($slug){
        $category = Category::where('slug',$slug)->first();
        $posts = $category->posts()->published()->paginate(10);
        // $categories = Category::all();
        // debugar()->info($posts);
        return view('categoryPost',compact('posts'));
    }


    public function register(){
        // $ip = $request->ip();
        // $country = request()->ip();

        // $data = Location::get($ip);

            // $ip = '2.57.220.0';
            // $ucountry = @unserialize(file_get_contents("http://ip-api.com/php/{country}"));
       

        // dd($ucountry);

        // return view('auth.register',compact('ucountry'));


    }

    public function ip_details()
    {
        $ip = '103.239.147.187'; //For static IP address get
        //$ip = request()->ip(); //Dynamic IP address get
       
        // $data = FacadesLocation::get($ip); 

        // $position = Location::get($ip);
        // $poisiton2 = FacadesLocation::get($ip);

        // dd($position);               
        return view('details',compact('data'));
    }





    public function subscription(){
        return view('subscription');
    }

    public function cart(){
        return view('cart');
    }

    public function career(){
        return view('career');
    }





    public function about(){
        return view('about');
    }

    public function aboutmaga(){
        return view('aboutmagazine');
    }

    public function mission(){
        return view('mission');
    }
    
    public function contact(){
        return view('contact');
    }
    public function searches(){
        return view('searches');
    }

    public function privecy(){
        return view('privecy');
    }

    public function terms(){
        return view('terms');
    }

    public function advertisment(){
        return view('advertisment');
    }

    public function marketplace(){
        return view('marketplace');
    }

    public function faq(){
        return view('faq');
    }
    
    public function magazineteam(){
        return view('magazineteam');
    }

    



    public function searchp(Request $request){
        // dd($request->searchp);
        $this->validate($request, ['searchp'=>'required|max:255']);
        $search = $request->searchp;
        $posts = Post::where('title','like',"%$search%")->paginate(10);
        $posts->appends(['search'=>$search]);

        // $categories = Category::all();
        return view('searchp', compact('posts','search'));

    }






    public function search(Request $request){
        $this->validate($request, ['search'=>'required|max:255']);
        $search = $request->search;
        $posts = Post::where('created_at','like',"%$search%")->paginate(10);
        $posts->appends(['search'=>$search]);

        // $categories = Category::all();
        return view('search', compact('posts','search'));

    }


    public function tagPosts($name){
        $query = $name;
        $tags = Tag::where('name','like',"%$name%")->paginate(10);
        $tags->appends(['search' => $name]);

        return view('tagPosts', compact('tags', 'query'));
    }

    public function likePost($post){
        //check if user already like or not
        $user = Auth::user();
        $likePost = $user->likedPosts()->where('post_id',$post)->count();
        if($likePost == 0){
            $user->likedPosts()->attach($post);
        }else{
            $user->likedPosts()->detach($post);
        }
        return redirect()->back();

    }


    public function gallery(){

        $images = Photo::all();

        return view('gallery',compact('images'));
    }

    public function video(){

        $images = Photo::all();

        return view('video',compact('images'));
    }




}
