<?php

namespace App\Http\Controllers;

use App\Submission;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;

class SubmissionController extends Controller
{
   
    public function index()
    {
        return view('submission');
    }

    public function upload(Request $request){

        // dd($request); die;

        $this->validate($request,[
            'name' => 'required|max:100',
            'email' => 'required|max:50',
            'pic' => 'required|mimes:jpg,png,bmp,jpeg',
            'artical' =>'required|mimes:pdf,txt,doc,docx|max:2048',
            'cv' =>'required|mimes:pdf,txt,doc,docx|max:2048',
        ]);
        $image = $request->pic;
        $imageName = uniqid().Carbon::now()->timestamp.'.'.$image->getClientOriginalExtension();
        if(!Storage::disk('public')->exists('submission')){
            Storage::disk('public')->makeDirectory('submission');
        }
        //Image Croped 
        $img = Image::make($image)->resize(752, null, function($constraint){
            $constraint->aspectRatio();
            $constraint->upsize();

        })->stream();

        Storage::disk('public')->put('submission/'.$imageName,$img);



        $articalName = time().'.'.$request->artical->extension();  
        $request->artical->move(public_path('uploads'), $articalName);

        $cvName = time().'.'.$request->cv->extension();  
        $request->cv->move(public_path('uploads'), $cvName);



        
        $submission = new Submission();
        $submission->name = $request->name; 
        $submission->email = $request->email; 

        $submission->image = $imageName; 
        $submission->artical = $articalName;
        $submission->cv = $cvName;  

        $submission->save();



        return redirect()->back()->with('success','Item Uploaded successfully!');
















    }

   
}
